# Début programme de lecture de l'état enfoncé/relâché du bouton USR
# (USR est l'acronyme de User pour signifier bouton utilisateur)

# Le bouton USR est présent sur Plug'Uino et les Interfaces Plug'Uino
# Le bouton USR est connecté à D12.
# L'appui sur le bouton force D12 à la masse.
# Au repos le bouton n'interagit pas avec D12.
# -> la broche D12 doit être configurée en entrée numérique avec résistance de rappel au 5V active
# -> voir la représentation sur l'étiquette des interfaces Plug'Uino

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino
from time import sleep
#from sys import stdout

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno.
plugUno.samplingOn()

################################
# Configuration des E/S
################################
brocheBoutonUSR = plugUno.get_pin('d:12:ipu')
# -> d   : signifie mode tout-ou-rien
# -> 12  : numéro de la broche (2/3/4/5/6/7/8/9/10/11/12/13)
# -> ipu : mode Input_PullUp ou entrée avec résistance de rappel au 5V
# -------> peut etre 'i' si la résistance de rappel n'est pas désiré

# Patienter un peu permet d'obtenir une première lecture cohérente de D12.
sleep(0.1)

################################
# Utilisation
################################
# interrogation du niveau Haut/Bas de l'entrée tout-ou-rien brocheBoutonUSR :
# brocheBoutonUSR.read() : retourne True pour haut (5V) et False pour bas (0V)
etatBrocheD12 = brocheBoutonUSR.read();
print("\nEtat de USR au lancement du programme : ", end='')
# (end='' évite le saut de ligne)
if etatBrocheD12 : print("relâché")
else : print("enfoncé")


# Comportement de la boucle ci-dessous :
# - notifie sur la console Python du changement d'état du bouton USR
# - termine le programme si appuie long > 3s sur le bouton USR
SEUIL_TEMPS_APPUIE_LONG = 3 # secondes
INTERVAL_TEMPS_COMPTAGE = 0.02 # secondes
compteur = 0
print(
    "\nLecture en boucle de l\'état du bouton USR : "
    "\n(maintenir USR enfoncé plus de 3 secondes pour terminer)\n"
)
while True :

    # Patienter tant que D12 ne change pas d'état
    # -> si l'état est Bas (False / bouton enfoncé), nous chronometrons le temps appuyé.
    while (brocheBoutonUSR.read() is etatBrocheD12):
        
        # Si le bouton reste enfoncé :
        if etatBrocheD12 is False :

            # commencer/continuer à compter le temps écoulé.
            compteur += INTERVAL_TEMPS_COMPTAGE
            
            # Si le bouton reste enfoncé plus de 3 secondes terminer le programme.
            if compteur > SEUIL_TEMPS_APPUIE_LONG :
                
                print("\nAppui long détecté.\nFermeture du programme.")
                
                # Fermer la connexion à Plug'Uno avant de quitter.
                plugUno.exit()
                # Termine l'éxecution du programme Python.
                exit()

        # Sinon, réinitialiser à 0 la variable de comptage (bouton au repos).
        else : compteur = 0
                
        # Patienter entre deux lectures d'état de D12        
        sleep(INTERVAL_TEMPS_COMPTAGE)

    # Arrivé à cette ligne l'état du bouton a changé.
    etatBrocheD12 = not(etatBrocheD12)

    print("Le bouton USR est maintenant : ",end='')
    if etatBrocheD12 is True : # True est 5V (bouton relâché)
        print("relâché")
    else : # False est 0V ou bouton enfoncé
        print("enfoncé")

    # Arbitrairement, nous pouvons utiliser stdout à la place de print.
    # Offre la possibilité de modifier le contenu de la ligne affichée (ne fonctionne pas depuis IDLE)
    # -> Fonctionnement peut être démontrant en éxecutant ce programme depuis cmd -> python BoutonUSR_Basique.py
    # stdout.write("\rLe bouton USR relâché") if etatBrocheD12 else stdout.write("\rLe bouton USR enfoncé")
    # stdout.flush()

# Fin programme de lecture de l'état enfoncé/relâché du bouton USR
